<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\TeacherController;
use Illuminate\Support\Facades\Route;

//login route
Route::get('/login', [AuthController::class, 'showLogin'])->name('auth.login');

//admin route
Route::get('admin/dashboard', [AuthController::class, 'showAdminDashboard'])->name('admin.dashboard');
Route::get('admin/profile', [AuthController::class, 'adminProfile'])->name('admin.profile');


//student route
Route::get('student/dashboard', [StudentController::class, 'studentDashboard'])->name('student.dashboard');
Route::get('student/profile', [StudentController::class, 'studentProfile'])->name('student.profile');
Route::get('student/add-student', [StudentController::class, 'addStudent'])->name('student.addStudent');

//teacher route
Route::get('teacher/dashboard', [TeacherController::class, 'teacherDashboard'])->name('teacher.dashboard');
Route::get('teacher/profile', [TeacherController::class, 'teacherProfile'])->name('teacher.profile');
Route::get('teacher/add-teacher', [TeacherController::class, 'addTeacher'])->name('teacher.addTeacher');
